//
//  RootViewController.m
//  Performing Non-UI Related Tasks Asynchronously with GCD
//
//  Created by Vandad Nahavandipoor on 13/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "RootViewController.h"

@implementation RootViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Miejsce na kod inicjalizacyjny.
    }
    return self;
}

- (void)didReceiveMemoryWarning
{
    // Usunięcie widoków, które nie posiadają widoku nadrzędnego.
    [super didReceiveMemoryWarning];
    
    // Usunięcie wszelkich buforowanych danych, obrazów itd., które nie są obecnie używane.
}

- (NSString *) fileLocation{
  
  /* Pobranie nazwy katalogu dokumentów. */
  NSArray *folders = 
  NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,
                                      NSUserDomainMask,
                                      YES);
  
  /* Czy katalog został znaleziony? */
  if ([folders count] == 0){
    return nil;
  }
  
  /* Pobranie pierwszego katalogu z listy znalezionych. */
  NSString *documentsFolder = [folders objectAtIndex:0];
  
  /* Umieszczenie nazwy pliku na końcu ścieżki dostępu do znalezionego katalogu. */
  return [documentsFolder 
          stringByAppendingPathComponent:@"list.txt"];
  
}

- (BOOL) hasFileAlreadyBeenCreated{
  
  BOOL result = NO;
  
  NSFileManager *fileManager = [[NSFileManager alloc] init];
  if ([fileManager fileExistsAtPath:[self fileLocation]]){
    result = YES;
  }
  
  return result;
}

//- (void) viewDidAppear:(BOOL)paramAnimated{
//  
//  dispatch_queue_t concurrentQueue = 
//    dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
//  
//  /* Jeżeli na dysku nie znajduje się tablica zawierająca 10 000 losowo wybranych liczb, trzeba liczby te wygenerować, a następnie tak przygotowaną tablicę zapisać na dysku. */
//  dispatch_async(concurrentQueue, ^{
//    
//    NSUInteger numberOfValuesRequired = 10000;
//    
//    if ([self hasFileAlreadyBeenCreated] == NO){
//      dispatch_sync(concurrentQueue, ^{
//        
//        NSMutableArray *arrayOfRandomNumbers = 
//        [[NSMutableArray alloc] initWithCapacity:numberOfValuesRequired];
//        
//        NSUInteger counter = 0;
//        for (counter = 0;
//             counter < numberOfValuesRequired;
//             counter++){
//          unsigned int randomNumber = 
//          arc4random() % ((unsigned int)RAND_MAX + 1);
//          
//          [arrayOfRandomNumbers addObject:
//           [NSNumber numberWithUnsignedInt:randomNumber]];
//        }
//        
//        /* Teraz utworzoną tablicę trzeba zapisać na dysku. */
//        [arrayOfRandomNumbers writeToFile:[self fileLocation]
//                               atomically:YES];
//        
//      });
//    }
//    
//    __block NSMutableArray *randomNumbers = nil;
//    
//    /* Odczyt liczb z tablicy i ich posortowanie w kolejności rosnącej. */
//    dispatch_sync(concurrentQueue, ^{
//      
//      /* Jeżeli plik został teraz utworzony, należy go odczytać. */
//      if ([self hasFileAlreadyBeenCreated]){
//        randomNumbers = [[NSMutableArray alloc] 
//                         initWithContentsOfFile:[self fileLocation]];
//        
//        /* Sortowanie liczb. */
//        [randomNumbers sortUsingComparator:
//         ^NSComparisonResult(id obj1, id obj2) {
//           
//           NSNumber *number1 = (NSNumber *)obj1;
//           NSNumber *number2 = (NSNumber *)obj2;
//           return [number1 compare:number2];
//           
//         }];
//      }
//    });
//    
//    
//    dispatch_async(dispatch_get_main_queue(), ^{
//      if ([randomNumbers count] > 0){
//        /* Odświeżenie interfejsu użytkownika poprzez wyświetlenie liczb z tablicy randomNumbers. */
//      }
//    });
//    
//  });
//  
//}

- (void) viewDidAppear:(BOOL)paramAnimated{
  
  dispatch_queue_t concurrentQueue = 
  dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
  
  dispatch_async(concurrentQueue, ^{
    
    __block UIImage *image = nil;
    
    dispatch_sync(concurrentQueue, ^{
      /* W tym miejscu pobieramy obraz. */
      /* Obraz przedstawia iPad i pochodzi z witryny Apple.
      Adres URL został podzielony, bo jest zbyt długi, aby zmieścił się w jednym wierszu. */
      NSString *urlAsString = @"http://images.apple.com/mobileme/features"\
                              "/images/ipad_findyouripad_20100518.jpg";
      
      NSURL *url = [NSURL URLWithString:urlAsString];
      
      NSURLRequest *urlRequest = [NSURLRequest requestWithURL:url];
      
      NSError *downloadError = nil;
      NSData *imageData = [NSURLConnection 
                           sendSynchronousRequest:urlRequest
                           returningResponse:nil
                           error:&downloadError];
      
      if (downloadError == nil &&
          imageData != nil){
        
        image = [UIImage imageWithData:imageData];
        /* Mamy już obraz, więc możemy go użyć. */
        
      }
      else if (downloadError != nil){
        NSLog(@"Wystąpił błąd = %@", downloadError);
      } else {
        NSLog(@"Z podanego adresu URL nie zostały pobrane dane.");
      }
      
    });
    
    dispatch_sync(dispatch_get_main_queue(), ^{
      /* Wyświetlenie obrazu użytkownikowi za pomocą kolejki głównej. */
      
      if (image != nil){
        /* Utworzenie widoku obrazu. */
        UIImageView *imageView = [[UIImageView alloc] 
                                  initWithFrame:self.view.bounds];
        
        /* Przypisanie obrazu widokowi. */
        [imageView setImage:image];
        
        /* Upewniamy się, że obraz został prawidłowo przeskalowany. */
        [imageView setContentMode:UIViewContentModeScaleAspectFit];
        
        /* Dodanie obrazu do widoku kontrolera widoku. */
        [self.view addSubview:imageView];
        
      } else {
        NSLog(@"Obraz nie został pobrany. Nie ma nic, co można wyświetlić.");
      }
      
    });
    
  });
  
}

#pragma mark - Cykl życiowy widoku

/*
// Implementacja metody loadView w celu programowego utworzenia hierarchii widoku bez używania pliku nib.
- (void)loadView
{
}
*/

/*
// Implementacja metody viewDidLoad w celu przeprowadzenia wszelkiej konfiguacji dodatkowej po wczytaniu widoku, najczęściej z pliku nib.
- (void)viewDidLoad
{
    [super viewDidLoad];
}
*/

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Usunięcie wszystkich "przytrzymanych" podwidoków widoku głównego,
// na przykład self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Zwrot wartości YES dla obsługiwanych układów.
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

@end
